<?php

defined('BASEPATH') || exit('No direct script access allowed');

require_once __DIR__ . '/../WhatsbotapiController.php';

use Whatsbotapi\WhatsbotapiController;

class Cannedreply extends WhatsbotapiController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('whatsbotapi_model');
        $this->load->model('canned_reply_model');
        $this->load->library('app_modules');
        $this->load->helper('whatsbotapi');

        if ($this->app_modules->is_inactive('whatsbot')) {
            $this->response(isWhatsbotNotActive()['response'], isWhatsbotNotActive()['response_code']);
        }

        register_language_files('whatsbotapi');
        load_client_language();

        if (isWbAuthorized()) {
            $this->response(isWbAuthorized()['response'], isWbAuthorized()['response_code']);
        }
    }

    public function cannedreply_get()
    {
        if (!empty($this->get()) && !in_array('id', array_keys($this->get()))) {
            $this->response(['message' => _l('something_went_wrong')], 500);
        }

        if (isset($this->get()['id']) && !is_numeric($this->get('id'))) {
            $this->response(['message' => _l('id_must_be_numeric')], 500);
        }

        $cannedreplyID   = $this->get('id');
        $replyData = $this->whatsbotapi_model->getTable('wtc_canned_reply', $cannedreplyID);

        $this->response($replyData['response'], $replyData['response_code']);
    }

    public function cannedreply_post()
    {
        $requiredData = [
            'title' => '',
            'description' => '',
            'added_from' => 1
        ];
        $postData = $this->input->post();
        $postData = array_merge($requiredData, $postData);
        $this->load->library('form_validation');

        $this->form_validation->set_data($postData);

        $postData['is_public'] = (isset($postData['is_public']) && $postData['is_public'] == 0) ? 0 : 1;

        $this->form_validation->set_rules('title', _l('title'), 'required');
        $this->form_validation->set_rules('description', _l('description'), 'required');

        if ($this->form_validation->run() === FALSE) {
            $this->response(['message' => strip_tags(validation_errors())], 422);
        }

        $res = $this->canned_reply_model->add($postData);

        ($res['type'] == 'success') ? $this->response(['message' => _l('reply_added_successfully')], 200) : $this->response(['message' => _l('something_went_wrong')], 400);
    }

    public function cannedreply_delete()
    {
        if (empty($this->get()) && !in_array('id', array_keys($this->get()))) {
            $this->response(['message' => _l('something_went_wrong')], 500);
        }

        if (isset($this->get()['id']) && !is_numeric($this->get('id'))) {
            $this->response(['message' => _l('id_must_be_numeric')], 500);
        }

        $reply_id = $this->get();
        $res = $this->canned_reply_model->delete_reply($reply_id);

        ($res['status']) ? $this->response(['message' => _l('reply_deleted_successfully')], 200) : $this->response(['message' => _l('no_record_found')], 500);
    }
}
