<?php

defined('BASEPATH') || exit('No direct script access allowed');

require_once __DIR__ . '/../WhatsbotapiController.php';
require_once __DIR__ . '/../../../whatsbot/vendor/autoload.php';

use Whatsbotapi\WhatsbotapiController;

class Connectaccount extends WhatsbotapiController
{
    use modules\whatsbot\traits\Whatsapp;
    public function __construct()
    {
        parent::__construct();

        $this->load->model('whatsbotapi_model');
        $this->load->model('whatsbot/whatsbot_model');
        $this->load->library('app_modules');
        $this->load->library('form_validation');
        $this->load->helper('whatsbotapi');

        if ($this->app_modules->is_inactive('whatsbot')) {
            $this->response(isWhatsbotNotActive()['response'], isWhatsbotNotActive()['response_code']);
        }

        register_language_files('whatsbotapi');
        load_client_language();

        if (isWbAuthorized()) {
            $this->response(isWbAuthorized()['response'], isWbAuthorized()['response_code']);
        }
    }

    // Action  to connect business account with module
    public function connectaccount_post()
    {
        $required_data = [
            'business_account_id' => '',
            'access_token' => ''
        ];

        $postData = $this->post();
        $postData = array_merge($required_data, $postData);

        $this->form_validation->set_data($postData);
        $this->form_validation->set_rules('business_account_id', _l('business_account_id'), 'required');
        $this->form_validation->set_rules('access_token', _l('access_token'), 'required');

        if ($this->form_validation->run() === FALSE) {
            $this->response(['message' => strip_tags(validation_errors())], 422);
        }

        update_option('wac_business_account_id', $this->input->post('business_account_id'), 0);
        update_option('wac_access_token', $this->input->post('access_token'), 0);
        $response = $this->whatsbot_model->load_templates();

        if (false == $response['success']) {
            $this->response(['message' => _l('provide_valid_account_id_token')], 500);
        } else {
            $phone_numbers = $this->getPhoneNumbers();
            $profile_data = $this->getProfile();
            update_option('wac_phone_number_id', $phone_numbers['data'][array_key_first($phone_numbers['data'])]->id, 0);
            if (isset($profile_data['data']) && isset($profile_data['data']->profile_picture_url)) {
                update_option('wac_profile_picture_url', $profile_data['data']->profile_picture_url, 0);
            } else {
                update_option('wac_profile_picture_url', '');
            }
            $default_number = $phone_numbers['data'][array_key_first($phone_numbers['data'])]->display_phone_number;
            update_option('wac_default_phone_number', preg_replace('/\D/', '', $default_number), 0);
            $this->response(['message' => _l('account_connected')], 200);
        }
    }
}
