<?php

defined('BASEPATH') || exit('No direct script access allowed');

require_once __DIR__ . '/../WhatsbotapiController.php';

use Whatsbotapi\WhatsbotapiController;

class Mergefields extends WhatsbotapiController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('whatsbotapi_model');
        $this->load->library('app_modules');
        $this->load->helper(['whatsbotapi', 'whatsbot/whatsbot']);

        if ($this->app_modules->is_inactive('whatsbot')) {
            $this->response(isWhatsbotNotActive()['response'], isWhatsbotNotActive()['response_code']);
        }

        register_language_files('whatsbotapi');
        load_client_language();

        if (isWbAuthorized()) {
            $this->response(isWbAuthorized()['response'], isWbAuthorized()['response_code']);
        }
    }

    public function mergefields_get()
    {
        if (!empty($this->get()) && !in_array('type', array_keys($this->get()))) {
            $this->response(['message' => _l('something_went_wrong')], 500);
        }
        $type = (isset($this->get()['type'])) ? $this->get('type') : null;

        if ($type != null && !in_array($type, ['leads', 'contacts'])) {
            $this->response(['message' => _l('type_must_be_leads_or_contacts')], 500);
        } else {
            $res = $this->whatsbotapi_model->getMergeFields($type);
            $this->response($res['response'], $res['response_code']);
        }

        $res = $this->whatsbotapi_model->getMergeFields();
        $this->response($res['response'], $res['response_code']);
    }
}
