<?php

defined('BASEPATH') || exit('No direct script access allowed');

require_once __DIR__ . '/../WhatsbotapiController.php';

use Whatsbotapi\WhatsbotapiController;

class Relationtypedata extends WhatsbotapiController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('whatsbotapi_model');
        $this->load->library('app_modules');
        $this->load->helper('whatsbotapi');

        if ($this->app_modules->is_inactive('whatsbot')) {
            $this->response(isWhatsbotNotActive()['response'], isWhatsbotNotActive()['response_code']);
        }

        register_language_files('whatsbotapi');
        load_client_language();

        if (isWbAuthorized()) {
            $this->response(isWbAuthorized()['response'], isWbAuthorized()['response_code']);
        }
    }

    public function relationtypedata_get()
    {
        if (!empty($this->get()) && !in_array('type', array_keys($this->get()))) {
            $this->response(['message' => _l('something_went_wrong')], 500);
        }

        $type = $this->get('type');
        if (!empty($type) && in_array($type, ['leads', 'contacts'])) {
            $relationData = $this->whatsbotapi_model->relationData($type);
            $this->response($relationData['response'], $relationData['response_code']);
        } else {
            $this->response(['message' => _l('type_must_be_leads_or_contacts')], 500);
        }
    }
}
