<?php

defined('BASEPATH') || exit('No direct script access allowed');

require_once __DIR__ . '/../WhatsbotapiController.php';

use Whatsbotapi\WhatsbotapiController;

class Templates extends WhatsbotapiController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('whatsbotapi_model');
        $this->load->library('app_modules');
        $this->load->helper('whatsbotapi');

        if ($this->app_modules->is_inactive('whatsbot')) {
            $this->response(isWhatsbotNotActive()['response'], isWhatsbotNotActive()['response_code']);
        }

        register_language_files('whatsbotapi');
        load_client_language();

        if (isWbAuthorized()) {
            $this->response(isWbAuthorized()['response'], isWbAuthorized()['response_code']);
        }
    }

    /**
     * @api {get} /whatsbotapi/v1/templates List All Templates
     *
     * @apiVersion 1.0.0
     *
     * @apiName GetAllTemplates
     *
     * @apiGroup Templates
     *
     * @apiHeader {String} Authorization <span class="btn btn-xs btn-danger">Required</span> Basic Access Authentication token.
     *
     * @apiSampleRequest /whatsbotapi/v1/templates
     *
     * @apiSuccess {Boolean} status  Response status.
     * @apiSuccess {Array}   data    Templates information.
     * @apiSuccess {String}  message Success message.
     *
     * @apiSuccessExample Success-Response:
     *     HTTP/1.1 200 OK
     *     {
     *         "status": true,
     *         "data": [
     *             {
     *                 "id": "1",
     *                 "template_id": "559989593050190",
     *                 "template_name": "testing_template",
     *                 "language": "en",
     *                 "status": "APPROVED",
     *                 "category": "MARKETING",
     *                 "header_data_format": "TEXT",
     *                 "header_data_text": "this is header line {{1}}",
     *                 "header_params_count": "1",
     *                 "body_data": "Hello this is one {{1}} *bold* 😀 ```monospace text``` {{2}} {{3}}",
     *                 "body_params_count": "3",
     *                 "footer_data": "footer text",
     *                 "footer_params_count": "0",
     *                 "buttons_data": "{\"type\":\"BUTTONS\",\"buttons\":[{\"type\":\"QUICK_REPLY\",\"text\":\"Stop promotions\"}]}"
     *             },
     *             {
     *                 "id": "3",
     *                 "template_id": "446678068149439",
     *                 "template_name": "college_course_information",
     *                 "language": "en",
     *                 "status": "APPROVED",
     *                 "category": "MARKETING",
     *                 "header_data_format": "TEXT",
     *                 "header_data_text": "CTL Group of College",
     *                 "header_params_count": "0",
     *                 "body_data": "\"Hello! 👋 Welcome to CTL Group College. How can I assist you today? Please choose an option:\n\n1. Admission Enquiry\n2. Course Information\n3. Schedule a Campus Visit\"",
     *                 "body_params_count": "0",
     *                 "footer_data": null,
     *                 "footer_params_count": "0",
     *                 "buttons_data": "{\"type\":\"BUTTONS\",\"buttons\":[{\"type\":\"QUICK_REPLY\",\"text\":\"Admission Enquiry\"},{\"type\":\"QUICK_REPLY\",\"text\":\"Course Information\"},{\"type\":\"QUICK_REPLY\",\"text\":\"Schedule a Campus Visit\"}]}"
     *             },
     *             {
     *                 "id": "2",
     *                 "template_id": "958186559334198",
     *                 "template_name": "hello_world",
     *                 "language": "en_US",
     *                 "status": "APPROVED",
     *                 "category": "UTILITY",
     *                 "header_data_format": "TEXT",
     *                 "header_data_text": "Hello World",
     *                 "header_params_count": "0",
     *                 "body_data": "Welcome and congratulations!! This message demonstrates your ability to send a WhatsApp message notification from the Cloud API, hosted by Meta. Thank you for taking the time to test with us.",
     *                 "body_params_count": "0",
     *                 "footer_data": "WhatsApp Business Platform sample message",
     *                 "footer_params_count": "0",
     *                 "buttons_data": "[]"
     *             }
     *         ],
     *         "message": "Data retrieved successfully"
     *     }
     *
     * @apiError {Boolean} status  Response status.
     * @apiError {String}  message No data found.
     *
     * @apiErrorExample Error-Response:
     *     HTTP/1.1 404 Not Found
     *     {
     *       "status": false,
     *       "message": "No data found"
     *     }
     */

    /**
     * @api {get} /whatsbotapi/v1/templates/id/:id Request Template By ID
     *
     * @apiVersion 1.0.0
     *
     * @apiName GetTemplateById
     *
     * @apiGroup Templates
     *
     * @apiHeader {String} Authorization <span class="btn btn-xs btn-danger">Required</span> Basic Access Authentication token.
     *
     * @apiParam {Number} id <span class="btn btn-xs btn-danger">Required</span> Template unique ID.
     *
     * @apiSampleRequest /whatsbotapi/v1/templates/id/1
     *
     * @apiSuccess {Boolean} status  Response status.
     * @apiSuccess {Object}  data    Template information.
     * @apiSuccess {String}  message Success message.
     *
     * @apiSuccessExample Success-Response:
     *     HTTP/1.1 200 OK
     *     {
     *         "status": true,
     *         "data": {
     *             "id": "1",
     *             "template_id": "559989593050190",
     *             "template_name": "testing_template",
     *             "language": "en",
     *             "status": "APPROVED",
     *             "category": "MARKETING",
     *             "header_data_format": "TEXT",
     *             "header_data_text": "this is header line {{1}}",
     *             "header_params_count": "1",
     *             "body_data": "Hello this is one {{1}} *bold* 😀 ```monospace text``` {{2}} {{3}}",
     *             "body_params_count": "3",
     *             "footer_data": "footer text",
     *             "footer_params_count": "0",
     *             "buttons_data": "{\"type\":\"BUTTONS\",\"buttons\":[{\"type\":\"QUICK_REPLY\",\"text\":\"Stop promotions\"}]}"
     *         },
     *         "message": "Data retrieved successfully"
     *     }
     *
     * @apiError {Boolean} status  Response status.
     * @apiError {String}  message Error message.
     *
     * @apiErrorExample Error-Response:
     *     HTTP/1.1 404 Not Found
     *     {
     *       "status": false,
     *       "message": "No data found"
     *     }
     */

    public function templates_get()
    {
        if (!empty($this->get()) && !in_array('id', array_keys($this->get()))) {
            $this->response(['message' => _l('something_went_wrong')], 500);
        }

        if (isset($this->get()['id']) && !is_numeric($this->get('id'))) {
            $this->response(['message' => _l('id_must_be_numeric')], 500);
        }

        $templateID   = $this->get('id');
        $templateData = $this->whatsbotapi_model->getTable('wtc_templates', $templateID);

        $this->response($templateData['response'], $templateData['response_code']);
    }

    // public function templates_post(){
    //     echo 
    // }
}
