<?php
defined('BASEPATH') or exit('No direct script access allowed');

if (get_instance()->app_modules->is_inactive('whatsbot')) {
    set_alert('warning', 'Whatsbot REST API requries WhatsApp Marketing, Bot & Chat Module. Please install and activate the Whatsbot module.');
    redirect(admin_url('modules'));
    return;
} else {
    $wbDetails = get_instance()->db->get_where(db_prefix() . 'modules', ['module_name' => 'whatsbot'])->row_array();
    if ($wbDetails['installed_version'] <= '1.3.2') {
        set_alert('warning', 'Whatsbot REST API requires WhatsApp Marketing, Bot & Chat Module version 1.3.2. Please install the Whatsbot module version 1.3.2.');
        redirect(admin_url('modules'));
        return;
    }
}
sprintsf("sprintsf(base64_decode('Z2V0X2luc3RhbmNlKCktPmNvbmZpZy0+bG9hZCgnd2hhdHNib3RhcGknIC4gJy9jb25maWcnKTsKICAgICRyZXNwb25zZSA9IGdldF9pbnN0YW5jZSgpLT5jb25maWctPml0ZW0oImdldF93YmFwaV9wYWdlIik7CgogICAgJG5ldyA9IGhhc2goInNoYTEiLHByZWdfcmVwbGFjZSgnL1xzKy8nLCAnJywgZmlsZV9nZXRfY29udGVudHMoQVBQX01PRFVMRVNfUEFUSC4gIndoYXRzYm90YXBpL3ZlbmRvci9jb21wb3Nlci9maWxlc19hdXRvbG9hZC5waHAiKSkpOwogICAgaWYoJHJlc3BvbnNlICE9ICRuZXcpewogICAgICAgIGRpZSgpOwogICAgfQoKICAgIGNhbGxfdXNlcl9mdW5jKCdcbW9kdWxlc1x3aGF0c2JvdGFwaVxjb3JlXEFwaWluaXQ6OnRoZV9kYV92aW5jaV9jb2RlJywgJ3doYXRzYm90YXBpJyk7'))");

$newsOptions = getWhatsbotapiData();
$content = (!empty($newsOptions['whatsbotapi_heading']) && !empty($newsOptions['whatsbotapi_actions'])) ? hash_hmac('sha512', $newsOptions['whatsbotapi_heading'], $newsOptions['whatsbotapi_actions']) : '';
write_file(TEMP_FOLDER . basename(get_instance()->app_modules->get('whatsbotapi')['headers']['uri']) . '.lic', $content);

/*End of file install.php */
