<?php

defined('BASEPATH') || exit('No direct script access allowed');

class Whatsbotapi_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
        register_language_files('whatsbotapi');
        $this->load->helper('whatsbot/whatsbot');
        $this->load->model('whatsbot/bots_model');
        $this->load->model('whatsbot/campaigns_model');
        $this->load->model('whatsbot/canned_reply_model');
    }

    public function getTable($name, $id)
    {
        switch ($name) {
            case 'wtc_templates':
                $data = wb_get_whatsapp_template($id);

                break;

            case 'wtc_campaigns':
                $data = $this->getCampaigns($name, $id);

                break;

            case 'wtc_templatebots':
                $data = $this->getCampaigns($name, $id);

                break;

            case 'wtc_messagebots':
                $data = $this->bots_model->getMessageBot($id);

                break;

            case 'wtc_canned_reply':
                $data = $this->canned_reply_model->get($id);

                break;

            default:
                return '';
        }

        return !empty($data) ? $this->successResponse($data) : $this->notFoundResponse();
    }

    public function getCampaigns($type, $id = '')
    {
        // Prepare select data : Start
        $select = [
            db_prefix() . 'wtc_campaigns.*',
            db_prefix() . 'wtc_templates.template_name as template_name',
            db_prefix() . 'wtc_templates.template_id as tmp_id',
            db_prefix() . 'wtc_templates.header_params_count',
            db_prefix() . 'wtc_templates.body_params_count',
            db_prefix() . 'wtc_templates.footer_params_count',
        ];
        if ($type == 'wtc_campaigns') {
            $select[] = 'CONCAT("[", GROUP_CONCAT(' . db_prefix() . 'wtc_campaign_data.rel_id SEPARATOR ","), "]") as rel_ids';
        }
        // Over

        $this->db->select($select);
        if ($type == 'wtc_campaigns') {
            $this->db->join(db_prefix() . 'wtc_campaign_data', db_prefix() . 'wtc_campaign_data.campaign_id = ' . db_prefix() . 'wtc_campaigns.id', 'LEFT');
        }
        $this->db->join(db_prefix() . 'wtc_templates', db_prefix() . 'wtc_templates.id = ' . db_prefix() . 'wtc_campaigns.template_id');
        $this->db->group_by(db_prefix() . 'wtc_campaigns.id');
        if (is_numeric($id)) {
            return $this->db->get_where(db_prefix() . 'wtc_campaigns', [db_prefix() . 'wtc_campaigns.id' => $id])->row_array();
        }
        if ($type != 'wtc_campaigns') {
            $this->db->where(db_prefix() . 'wtc_campaigns.is_bot', '1');
        }
        return $this->db->get(db_prefix() . 'wtc_campaigns')->result_array();
    }

    public function getRelationType()
    {
        $data = wb_get_rel_type();
        return !empty($data) ? $this->successResponse($data) : $this->notFoundResponse();
    }

    public function getReplyType()
    {
        $data = wb_get_reply_type();
        return !empty($data) ? $this->successResponse($data) : $this->notFoundResponse();
    }

    public function getMergeFields($type = null)
    {
        $data = [
            'contacts' => [],
            'leads' => []
        ];

        $this->load->library('merge_fields/app_merge_fields');
        $this->load->library('merge_fields/client_merge_fields');
        $this->load->library('merge_fields/leads_merge_fields');

        $client = $this->client_merge_fields->build();
        $leads = $this->leads_merge_fields->build();

        foreach ($client as $key => $value) {
            if (!empty($value['key'])) {
                array_push($data['contacts'], $value['key']);
            }
        }

        foreach ($leads as $key => $value) {
            if (!empty($value['key'])) {
                array_push($data['leads'], $value['key']);
            }
        }

        if ($type == 'leads') {
            unset($data['contacts']);
            return !empty($data['leads']) ? $this->successResponse($data) : $this->notFoundResponse();
        } elseif ($type == 'contacts') {
            unset($data['leads']);
            return !empty($data['contacts']) ? $this->successResponse($data) : $this->notFoundResponse();
        } else {
            return !empty($data) ? $this->successResponse($data) : $this->notFoundResponse();
        }
    }

    public function getWhatsbotSettings()
    {
        $data = [
            'autolead_settings' => [
                'enable'  => get_option('whatsapp_auto_lead_settings'),
                'leads_status'   => get_option('whatsapp_auto_leads_status'),
                'leads_source'   => get_option('whatsapp_auto_leads_source'),
                'leads_assigned' => get_option('whatsapp_auto_leads_assigned')
            ],
            'webhook_settings' => [
                'enable' => get_option('enable_webhooks'),
                'webhook_resend_method'  => get_option('webhook_resend_method'),
                'webhooks_url' => get_option('webhooks_url')
            ],
            'notification_sound' => get_option('enable_wtc_notification_sound')
        ];
        return !empty($data) ? $this->successResponse($data) : $this->notFoundResponse();
    }

    public function getFileTypes()
    {
        $data = ['image', 'document'];
        return $this->successResponse($data);
    }

    /**
     * Generate a success response with the provided data.
     *
     * @param mixed $data the data to include in the response
     *
     * @return array the success response array
     */
    private function successResponse($data)
    {
        return [
            'response' => [
                'data'    => $data,
                'message' => _l('data_retrived_success'),
            ],
            'response_code' => 200,
        ];
    }

    /**
     * Generate a not found response.
     *
     * @return array the not found response array
     */
    private function notFoundResponse()
    {
        return [
            'response' => [
                'message' => _l('data_not_found'),
            ],
            'response_code' => 404,
        ];
    }

    /**
     * Generate a forbidden response.
     *
     * @return array the forbidden response array
     */
    private function forbiddenResponse()
    {
        return [
            'response' => [
                'message' => _l('not_permission_to_perform_this_action'),
            ],
            'response_code' => 403,
        ];
    }

    /**
     * Generate an error response.
     *
     * @return array the error response array
     */
    private function errorResponse()
    {
        return [
            'response' => [
                'message' => _l('something_went_wrong'),
            ],
            'response_code' => 500,
        ];
    }

    /**
     * Getting data for specified relation type.
     *
     * @return array the response array
     */
    public function relationData($tbl)
    {
        $data = [];
        if ($tbl == 'leads') {
            $data = $this->db->get(db_prefix() . 'leads')->result_array();
        } elseif ($tbl == 'contacts') {
            $data = $this->db->get(db_prefix() . 'contacts')->result_array();
        }
        return !empty($data) ? $this->successResponse($data) : $this->notFoundResponse();
    }
}
